# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import stamp2datetime, datetime2stamp
import json


class BioTimeAppDateTime(object):

    """
    【DateTime Transform】 日期&时间戳转换
    """

    @ladonize(float, rtype=str)
    def stamp2datetime(self, stamp):
        """
        @param stamp: 日期时间戳
        @rtype:
        """
        dt = stamp2datetime(stamp)
        return json.dumps(dt.strftime('%Y-%m-%d %H:%M:%S'))

    @ladonize(str, rtype=str)
    def datetime2stamp(self, dt):
        """
        @param dt: 日期时间 2017-01-01 00:00:00/20170101000000
        @rtype:
        """
        # print "[*]dt", dt.decode('utf-8')
        stamp = datetime2stamp(dt)
        return json.dumps(stamp)
